 NICKDEMO.COM       E  ;ProgramtodemonstratesimpleuseoftheNickchip.
;
;

RAM0EQU0FCH;First16KofvideoRAM
RAM1EQU0FDH;Second----''-------
RAM2EQU0FEH;Third----''-------
RAM3EQU0FFH;Fourth----''-------

;Z80SPACEADDRESSES
;-------------------
SCREENEQU08000H;Startaddressforpixelscreen
LPTEQU0C000H;Startaddressoflineparametertable
STACKEQU0D000H;Z-80stack
;
;
;Dataareasusedforthelinedrawingdemoprogram
;
OFFSETEQU0D000H
COLOUREQU0D002H
COUNTEQU0D003H
;
BLUE_TABLEEQU0D100H
RED_TABLEEQU0D200H
;
X1EQU0;OffsetsintoREDandBLUEtables
Y1EQU1
X2EQU2
Y2EQU3
DELTA_X1EQU4
DELTA_Y1EQU5
DELTA_X2EQU6
DELTA_Y2EQU7
TABLEEQU8;16*4bytetable
;
;
;MISC.PARAMETERS
;----------------
NULEQU0;Nousevalue

BLACKEQU00000000B;Someusefulcolourstoputinthepalette
REDEQU01001001B
GREENEQU10010010B
YELLOWEQU11011011B
BLUEEQU00100100B
MAGENTAEQU01101101B
CYANEQU10110110B
WHITEEQU11111111B

;LINEPARAMETERMASKBITS
;------------------------
;MODEBYTE(byte1)
;---------

RELOADEQU001H;Reloadlineparametercounters
VBLANKEQU000H;UsemarginforVSYNC
PIXELEQU002H;Normalpixelmode
ATTREQU004H;ATTRIBUTEmode
CH256EQU006H;256fontCHARmode
CH128EQU008H;128fontCHARmode
CH64EQU00AH;64fontCHARmode
TPIXELEQU00CH;------futureexpansion-------
LPIXELEQU00EH;halfresolutionpixelmode

VRESEQU010H;lowverticalresolution

C2EQU000H;2-colourmode
C4EQU020H;4-colourmode
C16EQU040H;16-colourmode
C256EQU060H;256-colourmode

VINTEQU080H;TakeINTlow

;LEFTMARGIN(byte2)
;-----------
MSBALTEQU080H;AltcoloursonD7(pixelmode)0->2
LSBALTEQU040H;AltcoloursonD0(pixelmode)0->4

;RIGHTMARGIN(byte3)
;------------
ALTIND1EQU080H;AltcoloursonMSBofcharacterindex0->4
ALTIND0EQU040H;AltcoloursonnextMSBofcharindex0->2

;NICKCHIPI/OPORTS
;-------------------

FIXBIASEQU080H;Fixedcolourbias
BORDEREQU081H;Bordercolour
LPLEQU082H;Lineparameterpointer(A4-A11)
LPHEQU083H;Lineparameterpointer(A12-A15)

;LPHMASKBITS
;-------------

LPLOADEQU080H;ForceLOADofLPcounterlow
LPCLOCKEQU040H;ForceCLKofLPcounterhigh

PAGE0EQU0B0H;Pagein4Mof0000H-3FFFHinZ80space
PAGE1EQU0B1H;Pagein4Mof4000H-7FFFHinZ80space
PAGE2EQU0B2H;Pagein4Mof8000H-BFFFHinZ80space
PAGE3EQU0B3H;Pagein4MofC000H-FFFFHinZ80space

ORG0100H

DI

LDA,RAM2;PUTVIDEORAMINPAGES2AND3
OUT(PAGE2),A;(PAGE1NOTUSED,PAGE0ALREADY
INCA;HASTHISCODEIN)
OUT(PAGE3),A

LDA,0;SETBORDERCOLOUR
OUT(BORDER),A
LDA,067H;ANYOLDVALUEFORFIXEDCOLOURBIAS
OUT(FIXBIAS),A

LDSP,STACK;SETUPSTACKPOINTER

LDBC,ENTAB-LPTAB;COPYLINEPARAMETERTABLEINTOVIDEORAM
LDHL,LPTAB
LDDE,LPT
LDIR

LDA,low(LPT/16)
OUT(LPL),A;SETUPLINEPARAMETERPOINTER
LDA,high(LPT/16)
OUT(LPH),A;ENSURELPCOUNTERISLOADED(CLK=0,LOAD=0
ORLPCLOCK;CLK=1
OUT(LPH),A
ORLPLOAD;LOAD=1
OUT(LPH),A;THENLETITRUN
LDHL,SCREEN;CLEARTHESCREEN
LDDE,SCREEN+1
LDBC,256*64-1
LD(HL),0
LDIR

;---------------------------------------------------------------------------

;Thecodefromhereisjustamovinglinedemoprogramwhichuses
;theRAMfromSCREENupwardsasa4colour256*256pixelbitmappeddisplay
;

LDDE,RED_TABLE
LDHL,RED_INITIAL
CALLSETUP_TABLE

LDDE,BLUE_TABLE
LDHL,BLUE_INITIAL
CALLSETUP_TABLE


LOOP:LDA,11110000B
LD(COLOUR),A
LDHL,BLUE_TABLE
CALLITERATE

LDA,00001111B
LD(COLOUR),A
LDHL,RED_TABLE
CALLITERATE

LDA,(COUNT)
INCA
AND0FH
LD(COUNT),A

JRLOOP

;-----------------------------------------

ITERATE:PUSHHL
CALLNEW_XY
INCHL
INCHL
CALLNEW_XY

POPHL
PUSHHL
LDA,(COUNT)
ADDA,A
ADDA,A
ADDA,TABLE
LDE,A
LDD,0
ADDHL,DE

PUSHHL
CALLLINE

POPDE
POPHL
PUSHDE
LDBC,4
LDIR

POPHL

JPLINE

;-------------------------------------

SETUP_TABLE:LDBC,9
LDIR
LDH,D
LDL,E
DECHL
LDBC,16*4-1
LDIR
RET


RED_INITIAL:DB0,0,0,0,7,5,5,3,0
BLUE_INITIALDB255,0,255,0,256-5,5,256-9,3,0

;-------------------------------------

NEW_XY:PUSHHL
POPIY
CALLNEW_X_OR_Y
INCIY


NEW_X_OR_Y:LDA,R
AND0FH
LDC,A
OR0F0H
LDD,A

LDA,(IY+0)
LDB,(IY+4)
BIT7,B
JRNZDELTA_MINUS

ADDA,B
JRCOVERFLOW_PLUS
CPD
JRCNO_OVERFLOW
CPL
OVERFLOW_PLUS:CPL
JROVERFLOW

DELTA_MINUSADDA,B
JRNCOVERFLOW_MINUS
CPC
JRNCNO_OVERFLOW
OVERFLOW_MINUS:NEG

OVERFLOW:LD(IY+0),A
XORA
SUBB
LD(IY+4),A
RET

NO_OVERFLOW:LD(IY+0),A
RET

;----------------------------------------

LINE:LDE,(HL);GETTWOCO-ORDINATEPAIRS
INCHL;INTODEANDHL
LDD,(HL)
INCHL
LDA,(HL)
INCHL
LDH,(HL)
LDL,A

LDA,H;STARTFROMLOWESTYCO-ORD
CPD;(inDE)
JRNCNO_REVERSE
EXDE,HL

NO_REVERSE:LDIX,NORMAL_X;IfstartingXishigherthan
LDA,L;finishingXthenflag
SUBE;reflectionisrequiredand
JRNCNO_REFLECT_X;negatebothXco-ordinates
LDIX,REFLECT_X
SUBL
LDE,A;E=startingX
NEG
SUBL
NO_REFLECT_X:EXX
LDC,A;C'=DELTA_X
EXX

LDA,H
SUBD;D=startingY
EXX
LDB,A;B'=DELTA_Y

LDIY,NORMAL_XY;IfDELTA_Yismorethan
CPC;DELTA_XthenflagXYreflection
JRCNO_REFLECT_XY;andswapDELTA_XandDELTA_Y
LDIY,REFLECT_XY
LDB,C
LDC,A
EXX
LDA,E
LDE,D
LDD,A
EXX
NO_REFLECT_XY:LDL,C
SRLL
LDH,0
LDA,C
EXX
ADDA,E
EXAF,AF'

LDB,D
LDC,E

LINE_LOOP:JP(IY)
NORMAL_X:XORA
SRLD
RRE
RLA
SRLD
RRE
RLA
SET7,D

LDHL,MASK_TAB
ADDA,L
LDL,A
LDA,(COLOUR)
AND(HL)
EXDE,HL
XOR(HL)
LD(HL),A

EXAF,AF'
CPC
RETZ
EXAF,AF'

INCC
EXX
XORA
LDD,A
LDE,B
SBCHL,DE
EXX
JPPLINE_LOOP
EXX
LDE,C
ADDHL,DE
EXX
INCB
JPLINE_LOOP

REFLECT_X:XORA
SUBE
LDE,A
JPNORMAL_X

NORMAL_XY:LDD,B
LDE,C
JP(IX)

REFLECT_XY:LDD,C
LDE,B
JP(IX)


MASK_TAB:DB10001000B
DB00100010B
DB01000100B
DB00010001B

LPTAB:

;
DB256-256,PIXEL+C4+VRES,14,14+32
DWSCREEN,0
DBBLACK,RED,BLUE,MAGENTA,0,0,0,0
;
DB256-5,LPIXEL,63,0
DB0,0,0,0,0,0,0,0,0,0,0,0
;
DB256-10,LPIXEL,4,63
DB0,0,0,0,0,0,0,0,0,0,0,0
;
DB256-4,VBLANK,4,63
DB0,0,0,0,0,0,0,0,0,0,0,0
;
DB256-1,VBLANK,63,4
DB0,0,0,0,0,0,0,0,0,0,0,0
;
DB256-30,LPIXEL,4,63
DB0,0,0,0,0,0,0,0,0,0,0,0
;
DB256-6,RELOAD+LPIXEL,63,0
DB0,0,0,0,0,0,0,0,0,0,0,0

ENTAB:DB0





END
